//
//  GSProgressWindowController.h
//  Glyphs
//
//  Created by Georg Seifert on 21.5.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GlyphsFileFormatProtocol.h>

@interface GSProgressWindowController : NSWindowController <GlyphsProgressProtocol>

@property (unsafe_unretained, nonatomic) IBOutlet NSTextField *messageField;
@property (unsafe_unretained, nonatomic) NSString *title;
@property (unsafe_unretained, nonatomic) NSString *message;
@property (unsafe_unretained, nonatomic) IBOutlet NSProgressIndicator *progress;
@property (unsafe_unretained, nonatomic) IBOutlet NSImageView *iconView;
@property (unsafe_unretained, nonatomic) IBOutlet NSButton *cancelButton;

@property (unsafe_unretained, nonatomic) id delegate;

@property (weak, nonatomic) NSObject<GlyphsProgressDelegate> *handler;

- (IBAction)cancelAction:(id)sender;

@end
